package w83b.w83bOperacionesPaso.w83bBandejaEntrada;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bLotesPreavisosBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bSolicitudPreaviso;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bGenerarFicheroVueltaAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		List resultado = (List)contexto.get("w83bListaPreavisos");
		W83bPreavisosBean preavisocabecera=(W83bPreavisosBean)resultado.get(0);
		
		Calendar fecha = Calendar.getInstance();
		String dia = Integer.toString(fecha.get(Calendar.DATE));
		String mes = Integer.toString(fecha.get(Calendar.MONTH));
		String annio = Integer.toString(fecha.get(Calendar.YEAR));
		
		StringBuffer nombreFichero=new StringBuffer(W83bClsConstantes.CUARENTA);
		nombreFichero.append("preavisoEJ").append("_");
		nombreFichero.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCodTerritorio(), "0", 2, true)).append("_");
		nombreFichero.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getC_sindi_007(), "0", 3, true)).append("_");
		nombreFichero.append(annio).append(mes).append(dia);
		nombreFichero.append(".txt");
		
		File fichero = new File(nombreFichero.toString());
        fichero.createNewFile();
        
        StringBuffer total = new StringBuffer();
        StringBuffer linea = new StringBuffer();
        
        //Registro de cabecera
        linea.append("1"); //Tipo de registro
        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCodTerritorio(), "0", 2, true)); //Cdigo de territorio del lote
        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getC_sindi_007(), " ", 3, true)); //Cdigo de sindicato
        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getCorrel_007(), " ", 3, true)); //Nmero correlativo
        linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preavisocabecera.getF_creacion_007()), " ", 8, true)); //Fecha creacin
        linea.append("\r\n");
        total.append(linea.toString());
        
        int numtrabtot=0;
        int cenafectot=0;
        
        //Registro de detalle
        for (int i=0; i<resultado.size(); i++){
        	W83bPreavisosBean preaviso=(W83bPreavisosBean)resultado.get(i);
        	linea = new StringBuffer();//NOPMD
        	linea.append("2"); //Tipo de registro
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCifpreaviso(), " ", 9, false)); //CIF/NIF
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getIdentfiscal(), " ", 1, true)); //Identificacin fiscal
        	String razonsocial="";
        	if (preaviso.getRazonSocialPreaviso()!=null){
        		if (preaviso.getRazonSocialPreaviso().length()>50){
            		razonsocial=preaviso.getRazonSocialPreaviso().substring(0,50);
            	}
            	else{
            		razonsocial=preaviso.getRazonSocialPreaviso().substring(0,preaviso.getRazonSocialPreaviso().length());
            	}
        	}
        	
        	linea.append(W83bUtilidades.rellenarCaracter(razonsocial, " ", 50, false)); //Razn social
        	String domicilio="";
        	if (preaviso.getDomic_008()!=null){
        		if (preaviso.getDomic_008().length()>50){
            		domicilio=preaviso.getDomic_008().substring(0,50);
            	}
            	else{
            		domicilio=preaviso.getDomic_008().substring(0,preaviso.getDomic_008().length());
            	}
        	}
        	
        	linea.append(W83bUtilidades.rellenarCaracter(domicilio, " ", 50, false)); //Domicilio
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getProvincia(), "0", 2, true)); //Territorio del centro de trabajo
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodMunicipio(), "0", 3, true)); //Municipio del centro de trabajo
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodpos_008(), "0", 5, true)); //Cdigo postal del centro de trabajo
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getTelefono_008(), " ", 15, false)); //Telfono
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getFax_008(), " ", 15, false)); //Fax
        	String email="";
        	if (preaviso.getEmail_008()!=null){
        		if (preaviso.getEmail_008().length()>50){
            		email=preaviso.getEmail_008().substring(0,50);
            	}else{
            		email=preaviso.getEmail_008().substring(0,preaviso.getEmail_008().length());
            	}
        	}
        	
        	linea.append(W83bUtilidades.rellenarCaracter(email, " ", 50, false)); //Email
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCnae_008(), " ", 4, false)); //CNAE
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getTerritsegsocial(), "0", 2, true)); //Territorio seguridad social
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumsegsocial(), " ", 7, false)); //Nmero seguridad social
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getDigcontsegsocial(), " ", 2, false)); //Control seguridad social
        	linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preaviso.getFecha_inicio()), " ", 8, true)); //Fecha inicio
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getC_conv_008(), " ", 3, true)); //Cdigo de convenio
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getS_parcial_008(), " ", 1, false)); //Eleccin parcial
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getGlobal_008(), " ", 1, false)); //Preaviso global        	
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getN_cenafec_008(), " ", 6, true)); //Nm centros afectados
        	cenafectot+=Integer.parseInt(preaviso.getN_cenafec_008());
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumtrab(), " ", 6, true)); //Nm trabajadores
        	numtrabtot+=Integer.parseInt(preaviso.getNumtrab());
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getAdmonemp_008(), " ", 1, false)); //Administracin/Empresa
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getC_sindi_007(), " ", 3, true)); //Cdigo de promotor
        	linea.append(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preaviso.getFechaRegES()), " ", 8, true)); //Fecha registro
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getNumRegES(), " ", 15, false)); //Nmero de registro
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getCodTerritorio(), "0", 2, true)); //Codificacin de preaviso (Territ)
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getAno_preaviso_008(), " ", 4, false)); //Ao
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getN_preaviso_008(), "0", 6, true)); //Nmero de preaviso
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getIdent_008(), " ", 50, false)); //Identificador
        	linea.append(W83bUtilidades.rellenarCaracter(preaviso.getObserv_008(), " ", 255, false)); //Observaciones
        	linea.append("\r\n");
        	total.append(linea.toString());
        }
        
        //Registro de control
        linea = new StringBuffer();
        linea.append("3"); //Tipo de registro
        linea.append(W83bUtilidades.rellenarCaracter(preavisocabecera.getN_preavisos_007(), "0", 3, true)); //Nmero total de preavisos
        linea.append(W83bUtilidades.rellenarCaracter(String.valueOf(cenafectot), " ", 9, true)); //Nmero total de centros afectados
        linea.append(W83bUtilidades.rellenarCaracter(String.valueOf(numtrabtot), " ", 9, true)); //Nmero total de trabajadores
        linea.append("\r\n");
        total.append(linea.toString());
        
        W83bDocBean docBean= new W83bDocBean();//NOPMD
		byte[] bytes = total.toString().getBytes();
		InputStream input=new ByteArrayInputStream(bytes);//NOPMD
		docBean.setFileData(input);
		docBean.setTamanyo(total.toString().getBytes().length);
		docBean.setNombre(nombreFichero.toString());
		W83bLotesPreavisosBean lotesPreavisosBean = new W83bLotesPreavisosBean();
		W83bSolicitudPreaviso solicitudPreaviso = new W83bSolicitudPreaviso();
		solicitudPreaviso.setCorrelativoFichero(preavisocabecera.getCorrel_007());
		solicitudPreaviso.setFechaCreacion(W83bUtilidades.rellenarCaracter(W83bUtilidades.formatoFechaFicheroVuelta(preavisocabecera.getF_creacion_007()), " ", 8, true));
		solicitudPreaviso.setListaPreavisos(new ArrayList(resultado));
		solicitudPreaviso.setSindicato(preavisocabecera.getC_sindi_007());
		solicitudPreaviso.setTerritorioCabecera(preavisocabecera.getCodTerritorio());
		solicitudPreaviso.setTotalCentrosAfectados(String.valueOf(cenafectot));
		solicitudPreaviso.setTotalNumeroTrabajadores(String.valueOf(numtrabtot));
		lotesPreavisosBean.setSolicitudPreaviso(solicitudPreaviso);
		lotesPreavisosBean.setCodLote(preavisocabecera.getLote());
		lotesPreavisosBean.setDocumentoImportadoOriginal(total.toString());
	    lotesPreavisosBean.setUsuarioBean((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));
	    lotesPreavisosBean.setIdioma((String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    lotesPreavisosBean.setNombreFichero(nombreFichero.toString());
		docBean.setLotesPreavisosBean(lotesPreavisosBean);
		contexto.set("w83bDocBean",docBean);
		
		Runtime garbage = Runtime.getRuntime();
	    System.runFinalization();
	    System.gc();  	   
	    garbage.gc();
	    
		return mapping.findForward("ok");
	}
		
}

